/*
 * Decompiled with CFR 0.152.
 */
package com.bvengo.soundcontroller.gui;

import com.bvengo.soundcontroller.Translations;
import com.bvengo.soundcontroller.Utils;
import com.bvengo.soundcontroller.VolumeData;
import com.bvengo.soundcontroller.gui.buttons.AudioButtonWidget;
import com.bvengo.soundcontroller.gui.buttons.TriggerButtonWidget;
import java.util.List;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7172;
import net.minecraft.class_7919;

public class VolumeWidgetEntry
extends class_4265.class_4266<VolumeWidgetEntry> {
    private final VolumeData volumeData;
    private final class_1144 soundManager;
    private final class_437 screen;
    private final class_315 gameOptions;
    private static final int sliderWidth = 310;
    private static final int buttonSize = 20;
    private static final int paddingAfterSearch = 8;
    private static final int paddingBetweenButtons = 4;
    public static final int totalWidth = 362;
    public class_7172<Double> volumeOption;
    public class_339 volumeSlider;
    public TriggerButtonWidget playSoundButton;
    public TriggerButtonWidget resetButton;

    public VolumeWidgetEntry(VolumeData volumeData, class_437 screen, class_315 gameOptions) {
        this.volumeData = volumeData;
        this.screen = screen;
        this.gameOptions = gameOptions;
        this.soundManager = class_310.method_1551().method_1483();
        this.init();
    }

    private int getPercentageValue(double value) {
        return (int)Math.round(value * 100.0);
    }

    private float getVolumeFromSlider(double value) {
        return (float)Math.round(value * (double)VolumeData.MAX_VOLUME.floatValue() * 100.0) / 100.0f;
    }

    private void addSlider() {
        this.volumeOption = new class_7172(this.volumeData.getId().toString(), class_7172.method_42399(), (prefix, value) -> {
            int volume = this.getPercentageValue(this.volumeData.getVolume().floatValue());
            if (volume == 0) {
                return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{prefix, class_5244.field_24333});
            }
            if ((float)volume > VolumeData.MAX_VOLUME.floatValue() * 100.0f || volume < 0) {
                return class_2561.method_43469((String)"options.generic_value", (Object[])new Object[]{prefix, class_2561.method_43470((String)(volume + "%")).method_27694(style -> style.method_36139(0xFF5555))});
            }
            return class_2561.method_43469((String)"options.percent_value", (Object[])new Object[]{prefix, volume});
        }, (class_7172.class_7178)class_7172.class_7177.field_37875, (Object)Math.clamp(this.volumeData.getVolume().doubleValue() / (double)VolumeData.MAX_VOLUME.floatValue(), 0.0, 1.0), value -> {
            this.volumeData.setVolume(this.getVolumeFromSlider((double)value));
            Utils.updateExistingSounds();
        });
        this.volumeSlider = this.volumeOption.method_18520(this.gameOptions, 0, 0, 310);
    }

    private void addPlayButton() {
        this.playSoundButton = new AudioButtonWidget(0, 0, 20, 20, this.soundManager, this.volumeData);
    }

    private void addResetButton() {
        this.resetButton = new TriggerButtonWidget("reset", 0, 0, 20, 20, button -> {
            this.volumeData.setVolume(VolumeData.DEFAULT_VOLUME.floatValue());
            this.addSlider();
            Utils.updateExistingSounds();
        });
        this.resetButton.method_47400(class_7919.method_47407((class_2561)Translations.RESET_BUTTON_TOOLTIP));
    }

    private void init() {
        this.addSlider();
        this.addPlayButton();
        this.addResetButton();
    }

    public void method_25343(class_332 context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
        int leftSide = (this.screen.field_22789 - 362) / 2;
        this.volumeSlider.method_48229(leftSide, y);
        this.volumeSlider.method_25394(context, mouseX, mouseY, tickDelta);
        this.playSoundButton.method_48229(this.volumeSlider.method_55442() + 8, y);
        this.playSoundButton.method_25394(context, mouseX, mouseY, tickDelta);
        this.resetButton.method_48229(this.playSoundButton.method_55442() + 4, y);
        this.resetButton.method_25394(context, mouseX, mouseY, tickDelta);
    }

    public List<? extends class_364> method_25396() {
        return List.of(this.volumeSlider, this.playSoundButton, this.resetButton);
    }

    public List<? extends class_6379> method_37025() {
        return List.of(this.volumeSlider, this.playSoundButton, this.resetButton);
    }
}

