/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.IColumnDataView;
import com.seibel.distanthorizons.core.util.ColorUtil;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointReducingList;
import com.seibel.distanthorizons.coreapi.ModInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RenderDataPointUtil {
    public static final boolean RUN_VALIDATION = ModInfo.IS_DEV_BUILD;
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int EMPTY_DATA = 0;
    public static final int MAX_WORLD_Y_SIZE = 4096;
    public static final int ALPHA_DOWNSIZE_SHIFT = 4;
    public static final int IRIS_BLOCK_MATERIAL_ID_SHIFT = 60;
    public static final int COLOR_SHIFT = 32;
    public static final int BLUE_SHIFT = 32;
    public static final int GREEN_SHIFT = 40;
    public static final int RED_SHIFT = 48;
    public static final int ALPHA_SHIFT = 56;
    public static final int HEIGHT_SHIFT = 20;
    public static final int DEPTH_SHIFT = 8;
    public static final int BLOCK_LIGHT_SHIFT = 4;
    public static final int SKY_LIGHT_SHIFT = 0;
    public static final long ALPHA_MASK = 15L;
    public static final long RED_MASK = 255L;
    public static final long GREEN_MASK = 255L;
    public static final long BLUE_MASK = 255L;
    public static final long COLOR_MASK = 0xFFFFFFL;
    public static final long HEIGHT_MASK = 4095L;
    public static final long DEPTH_MASK = 4095L;
    public static final long HEIGHT_DEPTH_MASK = 0xFFFFFFL;
    public static final long BLOCK_LIGHT_MASK = 15L;
    public static final long SKY_LIGHT_MASK = 15L;
    public static final long IRIS_BLOCK_MATERIAL_ID_MASK = 15L;
    public static final long COMPARE_SHIFT = 7L;
    public static final long HEIGHT_SHIFTED_MASK = 0xFFF00000L;
    public static final long DEPTH_SHIFTED_MASK = 1048320L;
    public static final long VOID_SETTER = 0xFFFFFF00L;

    public static long createDataPoint(int height, int depth, int color, int lightSky, int lightBlock, int irisBlockMaterialId) {
        return RenderDataPointUtil.createDataPoint(ColorUtil.getAlpha(color), ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), height, depth, lightSky, lightBlock, irisBlockMaterialId);
    }

    public static long createDataPoint(int alpha, int red, int green, int blue, int height, int depth, int lightSky, int lightBlock, int irisBlockMaterialId) {
        if (RUN_VALIDATION) {
            if (height < 0 || height >= 4096) {
                LodUtil.assertNotReach("Trying to create datapoint with height[" + height + "] out of range!");
            }
            if (depth < 0 || depth >= 4096) {
                LodUtil.assertNotReach("Trying to create datapoint with depth[" + depth + "] out of range!");
            }
            if (lightSky < 0 || lightSky >= 16) {
                LodUtil.assertNotReach("Trying to create datapoint with lightSky[" + lightSky + "] out of range!");
            }
            if (lightBlock < 0 || lightBlock >= 16) {
                LodUtil.assertNotReach("Trying to create datapoint with lightBlock[" + lightBlock + "] out of range!");
            }
            if (irisBlockMaterialId < 0 || irisBlockMaterialId >= 256) {
                LodUtil.assertNotReach("Trying to create datapoint with irisBlockMaterialId[" + irisBlockMaterialId + "] out of range!");
            }
            if (alpha < 0 || alpha >= 256) {
                LodUtil.assertNotReach("Trying to create datapoint with alpha[" + alpha + "] out of range!");
            }
            if (red < 0 || red >= 256) {
                LodUtil.assertNotReach("Trying to create datapoint with red[" + red + "] out of range!");
            }
            if (green < 0 || green >= 256) {
                LodUtil.assertNotReach("Trying to create datapoint with green[" + green + "] out of range!");
            }
            if (blue < 0 || blue >= 256) {
                LodUtil.assertNotReach("Trying to create datapoint with blue[" + blue + "] out of range!");
            }
            if (depth > height) {
                LodUtil.assertNotReach("Trying to create datapoint with depth[" + depth + "] greater than height[" + height + "]!");
            }
        }
        long out = (long)(alpha >>> 4) << 56 | ((long)red & 0xFFL) << 48 | ((long)green & 0xFFL) << 40 | ((long)blue & 0xFFL) << 32 | ((long)height & 0xFFFL) << 20 | ((long)depth & 0xFFFL) << 8 | ((long)lightBlock & 0xFL) << 4 | ((long)lightSky & 0xFL) << 0 | ((long)irisBlockMaterialId & 0xFL) << 60;
        return out;
    }

    public static long shiftHeightAndDepth(long dataPoint, short offset) {
        long height = dataPoint + ((long)offset << 20) & 0xFFF00000L;
        long depth = dataPoint + (long)(offset << 8) & 0xFFF00L;
        return dataPoint & 0xFFFFFFFF000000FFL | height | depth;
    }

    public static short getYMax(long dataPoint) {
        return (short)(dataPoint >>> 20 & 0xFFFL);
    }

    public static short getYMin(long dataPoint) {
        return (short)(dataPoint >>> 8 & 0xFFFL);
    }

    public static long setYMin(long dataPoint, int depth) {
        return dataPoint & 0xFFFFFFFFFFF000FFL | ((long)depth & 0xFFFL) << 8;
    }

    public static short getAlpha(long dataPoint) {
        return (short)((dataPoint >>> 56 & 0xFL) << 4 | 0xFL);
    }

    public static short getRed(long dataPoint) {
        return (short)(dataPoint >>> 48 & 0xFFL);
    }

    public static short getGreen(long dataPoint) {
        return (short)(dataPoint >>> 40 & 0xFFL);
    }

    public static short getBlue(long dataPoint) {
        return (short)(dataPoint >>> 32 & 0xFFL);
    }

    public static byte getLightSky(long dataPoint) {
        return (byte)(dataPoint >>> 0 & 0xFL);
    }

    public static byte getLightBlock(long dataPoint) {
        return (byte)(dataPoint >>> 4 & 0xFL);
    }

    public static byte getBlockMaterialId(long dataPoint) {
        return (byte)(dataPoint >>> 60 & 0xFL);
    }

    public static boolean isVoid(long dataPoint) {
        return (dataPoint >>> 8 & 0xFFFFFFL) == 0L;
    }

    public static boolean doesDataPointExist(long dataPoint) {
        return dataPoint != 0L;
    }

    public static int getColor(long dataPoint) {
        long alpha = RenderDataPointUtil.getAlpha(dataPoint);
        return (int)(dataPoint >>> 32 & 0xFFFFFFL | alpha << 24);
    }

    public static int compareDatapointPriority(long dataA, long dataB) {
        return (int)((dataA >> 7) - (dataB >> 7));
    }

    public static String toString(long dataPoint) {
        if (!RenderDataPointUtil.doesDataPointExist(dataPoint)) {
            return "null";
        }
        if (RenderDataPointUtil.isVoid(dataPoint)) {
            return "void";
        }
        return "Y+:" + RenderDataPointUtil.getYMax(dataPoint) + " Y-:" + RenderDataPointUtil.getYMin(dataPoint) + " argb:" + RenderDataPointUtil.getAlpha(dataPoint) + " " + RenderDataPointUtil.getRed(dataPoint) + " " + RenderDataPointUtil.getGreen(dataPoint) + " " + RenderDataPointUtil.getBlue(dataPoint) + " BL:" + RenderDataPointUtil.getLightBlock(dataPoint) + " SL:" + RenderDataPointUtil.getLightSky(dataPoint) + " MAT:" + RenderDataPointUtil.getBlockMaterialId(dataPoint) + "[" + (Object)((Object)EDhApiBlockMaterial.getFromIndex(RenderDataPointUtil.getBlockMaterialId(dataPoint))) + "]";
    }

    public static void mergeMultiData(IColumnDataView sourceData, ColumnArrayView output) {
        int target = output.verticalSize();
        if (target <= 0) {
            output.fill(0L);
        } else if (target == 1) {
            output.set(0, RenderDataPointReducingList.reduceToOne(sourceData));
            int size = output.size();
            for (int index = 1; index < size; ++index) {
                output.set(index, 0L);
            }
        } else {
            try (RenderDataPointReducingList list = new RenderDataPointReducingList(sourceData);){
                list.reduce(output.verticalSize());
                list.copyTo(output);
            }
        }
    }
}

