/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.dialog;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.EnumSet;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.io.ThemeLoader;
import journeymap.client.model.GridSpec;
import journeymap.client.model.GridSpecs;
import journeymap.client.model.MapType;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.buttons.CheckBox;
import journeymap.client.ui.component.buttons.FloatSliderButton;
import journeymap.client.ui.component.dropdown.PropertyDropdownButton;
import journeymap.client.ui.component.screens.JmUILegacy;
import journeymap.client.ui.theme.Theme;
import journeymap.client.ui.theme.ThemeToggle;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.mixin.client.GuiGraphicsAccessor;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.FloatField;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;

public class GridEditor
extends JmUILegacy {
    private final class_1043 colorPickTexture;
    private final int tileSize = 128;
    private final int sampleTextureSize = 128;
    private GridSpecs gridSpecs;
    private PropertyDropdownButton<GridSpec.Style> buttonStyle;
    private FloatSliderButton buttonOpacity;
    private CheckBox checkDay;
    private CheckBox checkNight;
    private CheckBox checkUnderground;
    private ThemeToggle buttonDay;
    private ThemeToggle buttonNight;
    private ThemeToggle buttonUnderground;
    private Integer activeColor;
    private MapType activeMapType;
    private Button buttonReset;
    private Button buttonCancel;
    private Button buttonClose;
    private Rectangle2D.Double colorPickRect;
    private ButtonList topButtons;
    private ButtonList leftButtons;
    private ButtonList leftChecks;
    private ButtonList bottomButtons;
    private class_2960 colorPicResource = Constants.birthdayMessage() == null ? TextureCache.ColorPicker : TextureCache.ColorPicker2;

    public GridEditor(class_437 returnDisplay) {
        super(Constants.getString("jm.common.grid_editor"), returnDisplay);
        this.colorPickTexture = TextureCache.getTexture(this.colorPicResource);
        this.colorPickRect = new Rectangle2D.Double(0.0, 0.0, ((TextureAccess)this.colorPickTexture).journeymap$getWidth(), ((TextureAccess)this.colorPickTexture).journeymap$getHeight());
        this.gridSpecs = JourneymapClient.getInstance().getCoreProperties().gridSpecs.clone();
        this.activeMapType = MapType.day((class_5321<class_1937>)class_1937.field_25179);
        this.activeColor = this.gridSpecs.getSpec(this.activeMapType).getColor();
    }

    @Override
    public void method_25426() {
        try {
            this.setRenderBottomBar(true);
            if (this.getRenderables().isEmpty()) {
                GridSpec spec = this.gridSpecs.getSpec(this.activeMapType);
                this.buttonStyle = new PropertyDropdownButton<GridSpec.Style>(EnumSet.allOf(GridSpec.Style.class), Constants.getString("jm.common.grid_style"), new EnumField<GridSpec.Style>(Category.Hidden, "", spec.style), b -> this.updateGridSpecs());
                this.method_37063((class_364)this.buttonStyle);
                this.buttonStyle.setDefaultStyle(false);
                this.buttonStyle.setDrawBackground(false);
                this.buttonOpacity = new FloatSliderButton(new FloatField(Category.Hidden, "", 0.0f, 1.0f, spec.alpha), Constants.getString("jm.common.grid_opacity") + " : ", "");
                this.method_37063((class_364)this.buttonOpacity);
                this.buttonOpacity.setDefaultStyle(false);
                this.buttonOpacity.setDrawBackground(false);
                this.topButtons = new ButtonList(this.buttonStyle, this.buttonOpacity);
                this.topButtons.equalizeWidths(this.getFontRenderer());
                this.checkDay = new CheckBox("", this.activeMapType == MapType.day((class_5321<class_1937>)class_1937.field_25179), b -> this.updatePreview(MapType.day((class_5321<class_1937>)class_1937.field_25179)));
                this.method_37063((class_364)this.checkDay);
                this.checkNight = new CheckBox("", this.activeMapType == MapType.night((class_5321<class_1937>)class_1937.field_25179), b -> this.updatePreview(MapType.night((class_5321<class_1937>)class_1937.field_25179)));
                this.method_37063((class_364)this.checkNight);
                this.checkUnderground = new CheckBox("", this.activeMapType.isUnderground(), b -> this.updatePreview(MapType.underground(0, (class_5321<class_1937>)class_1937.field_25179)));
                this.method_37063((class_364)this.checkUnderground);
                this.leftChecks = new ButtonList(this.checkDay, this.checkNight, this.checkUnderground);
                Theme theme = ThemeLoader.getCurrentTheme();
                this.buttonDay = new ThemeToggle(theme, "jm.fullscreen.map_day", "day", b -> this.updatePreview(MapType.day((class_5321<class_1937>)class_1937.field_25179)));
                this.method_37063((class_364)this.buttonDay);
                this.buttonNight = new ThemeToggle(theme, "jm.fullscreen.map_night", "night", b -> this.updatePreview(MapType.night((class_5321<class_1937>)class_1937.field_25179)));
                this.method_37063((class_364)this.buttonNight);
                this.buttonUnderground = new ThemeToggle(theme, "jm.fullscreen.map_caves", "caves", b -> this.updatePreview(MapType.underground(0, (class_5321<class_1937>)class_1937.field_25179)));
                this.method_37063((class_364)this.buttonUnderground);
                this.leftButtons = new ButtonList(this.buttonDay, this.buttonNight, this.buttonUnderground);
                this.buttonReset = new Button(Constants.getString("jm.waypoint.reset"), b -> this.resetGridSpecs());
                this.method_37063((class_364)this.buttonReset);
                this.buttonReset.setDefaultStyle(false);
                this.buttonCancel = new Button(Constants.getString("jm.waypoint.cancel"), b -> {
                    this.resetGridSpecs();
                    this.closeAndReturn();
                });
                this.buttonCancel.setDefaultStyle(false);
                this.method_37063((class_364)this.buttonCancel);
                this.buttonClose = new Button(Constants.getString("jm.waypoint.save"), b -> this.saveAndClose());
                this.buttonClose.setDefaultStyle(false);
                this.method_37063((class_364)this.buttonClose);
                this.bottomButtons = new ButtonList(this.buttonReset, this.buttonCancel, this.buttonClose);
                this.bottomButtons.equalizeWidths(this.getFontRenderer());
                this.getRenderables().addAll(this.topButtons);
                this.getRenderables().addAll(this.leftChecks);
                this.getRenderables().addAll(this.leftButtons);
                this.getRenderables().addAll(this.bottomButtons);
                this.updatePreview(this.activeMapType);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error(LogFormatter.toString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    @Override
    protected void layoutButtons(class_332 graphics) {
        try {
            this.method_25426();
            int hgap = 6;
            int vgap = 6;
            int startY = Math.max(40, (this.field_22790 - 230) / 2);
            int centerX = this.field_22789 / 2;
            int cpSize = this.topButtons.getHeight(6);
            int topRowWidth = 6 + cpSize + ((Button)((Object)this.topButtons.get(0))).method_25368();
            int topRowLeft = centerX - topRowWidth / 2;
            this.topButtons.layoutVertical(topRowLeft + 6 + cpSize, startY, true, 6);
            this.drawColorPicker(graphics, topRowLeft, this.topButtons.getTopY(), cpSize);
            int tileX = centerX - 64;
            int tileY = this.topButtons.getBottomY() + 12;
            class_4597.class_4598 buffers = ((GuiGraphicsAccessor)graphics).getBufferSource();
            this.drawMapTile(graphics, buffers, tileX, tileY);
            this.leftButtons.layoutVertical(tileX - ((Button)((Object)this.leftButtons.get(0))).method_25368() - 6, tileY + 6, true, 6);
            this.leftChecks.setHeights(((Button)((Object)this.leftButtons.get(0))).method_25364());
            this.leftChecks.setWidths(15);
            this.leftChecks.layoutVertical(this.leftButtons.getLeftX() - this.checkDay.method_25368(), this.leftButtons.getTopY(), true, 6);
            int bottomY = Math.min(tileY + 128 + 12, this.field_22790 - 10 - this.buttonClose.method_25364());
            this.bottomButtons.equalizeWidths(this.getFontRenderer(), 6, ((Button)((Object)this.topButtons.get(0))).getRightX() - topRowLeft);
            this.bottomButtons.layoutCenteredHorizontal(centerX, bottomY, true, 6);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.layoutButtons: " + LogFormatter.toString(t));
        }
    }

    @Override
    public void method_25394(class_332 graphics, int x, int y, float par3) {
        try {
            this.method_25420(graphics, x, y, par3);
            this.renderBottomBar(graphics);
            this.layoutButtons(graphics);
            for (int k = 0; k < this.getRenderables().size(); ++k) {
                class_4185 guibutton = (class_4185)this.getRenderables().get(k);
                guibutton.method_25394(graphics, x, y, 0.0f);
            }
            this.drawTitle(graphics);
            this.drawLogo(graphics);
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.render: " + LogFormatter.toString(t));
        }
    }

    protected void drawColorPicker(class_332 graphics, int x, int y, float size) {
        int sizeI = (int)size;
        graphics.method_25294(x - 1, y - 1, x + sizeI + 1, y + sizeI + 1, -6250336);
        float scale = size / (float)((TextureAccess)this.colorPickTexture).journeymap$getWidth();
        float height = (float)((TextureAccess)this.colorPickTexture).journeymap$getHeight() * scale;
        float width = (float)((TextureAccess)this.colorPickTexture).journeymap$getWidth() * scale;
        this.colorPickRect.setRect(x, y, size, size);
        class_1921 renderType = JMRenderTypes.getIcon((class_1044)this.colorPickTexture);
        class_4597.class_4598 buffers = ((GuiGraphicsAccessor)graphics).getBufferSource();
        class_4588 vertexBuilder = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics.method_51448(), vertexBuilder, 0xFFFFFF, 1.0f, (double)x, (double)y, (double)width, (double)height, 0.0, false);
        buffers.method_37104();
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        if (colorX > 0 && colorY > 0) {
            DrawUtil.drawRectangle(graphics, (colorX += x) - 2, (colorY += y) - 2, 5.0, 5.0, Color.darkGray.getRGB(), 0.8f);
            DrawUtil.drawRectangle(graphics, colorX - 1, colorY, 3.0, 1.0, this.activeColor, 1.0f);
            DrawUtil.drawRectangle(graphics, colorX, colorY - 1, 1.0, 3.0, this.activeColor, 1.0f);
        }
    }

    protected void drawMapTile(class_332 graphics, class_4597.class_4598 buffers, int x, int y) {
        graphics.method_25294(x - 1, y - 1, x + 128 + 1, y + 128 + 1, -6250336);
        class_1043 tileTex = this.getTileSample(this.activeMapType);
        class_1921 tileRenderType = JMRenderTypes.getIcon((class_1044)tileTex);
        class_4588 vertexBuilder = buffers.getBuffer(tileRenderType);
        DrawUtil.drawQuad(graphics.method_51448(), vertexBuilder, 0xFFFFFF, 1.0f, (double)x, (double)y, 128.0, 128.0, 0.0, false);
        buffers.method_37104();
        GridSpec gridSpec = this.gridSpecs.getSpec(this.activeMapType);
        class_1921 renderType = gridSpec.getRenderType(512);
        class_4588 regionTileBuffer = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics.method_51448(), regionTileBuffer, gridSpec.getColor(), gridSpec.alpha, x, y, 128.0, 128.0, 0.0, 0.0, 0.25, 0.25, 0.0, false);
        buffers.method_22994(renderType);
    }

    protected void drawLabel(class_332 graphics, String label, int x, int y) {
        graphics.method_25303(this.getFontRenderer(), label, x, y, Color.cyan.getRGB());
    }

    @Override
    public boolean method_25400(char typedChar, int keyCode) {
        try {
            switch (keyCode) {
                case 256: {
                    this.closeAndReturn();
                    return true;
                }
                case 257: {
                    this.saveAndClose();
                    return true;
                }
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.keyTyped: " + LogFormatter.toString(t));
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        try {
            if (this.buttonOpacity.dragging) {
                this.updateGridSpecs();
            } else {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClickMove: " + LogFormatter.toString(t));
        }
        return super.method_25403(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean method_25402(double mouseX, double mouseY, int mouseButton) {
        try {
            super.method_25402(mouseX, mouseY, mouseButton);
            if (mouseButton == 0) {
                this.checkColorPicker(mouseX, mouseY);
            }
        }
        catch (Throwable t) {
            this.logger.error("Error in GridEditor.mouseClicked: " + LogFormatter.toString(t));
        }
        return true;
    }

    protected void checkColorPicker(double mouseX, double mouseY) {
        if (this.colorPickRect.contains(mouseX, mouseY)) {
            int x = (int)(mouseX - (double)((int)this.colorPickRect.x));
            int y = (int)(mouseY - (double)((int)this.colorPickRect.y));
            int pixelX = (int)((double)x / this.colorPickRect.width * (double)((TextureAccess)this.colorPickTexture).journeymap$getWidth());
            int pixelY = (int)((double)y / this.colorPickRect.height * (double)((TextureAccess)this.colorPickTexture).journeymap$getHeight());
            int rgb = this.colorPickTexture.method_4525().method_61940(pixelX, pixelY);
            this.activeColor = RGB.rgbaToRgb(rgb);
            GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
            activeSpec.setColorCoords(x, y);
            this.updateGridSpecs();
        }
    }

    protected void updatePreview(MapType mapType) {
        this.activeMapType = mapType;
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        this.activeColor = activeSpec.getColor();
        this.buttonOpacity.setValue(activeSpec.alpha);
        this.buttonStyle.setValue(activeSpec.style);
        this.checkDay.setToggled(mapType.isDay());
        this.checkNight.setToggled(mapType.isNight());
        this.checkUnderground.setToggled(mapType.isUnderground());
        this.buttonDay.setToggled(mapType.isDay());
        this.buttonNight.setToggled(mapType.isNight());
        this.buttonUnderground.setToggled(mapType.isUnderground());
    }

    protected void updateGridSpecs() {
        GridSpec activeSpec = this.gridSpecs.getSpec(this.activeMapType);
        int colorX = activeSpec.getColorX();
        int colorY = activeSpec.getColorY();
        GridSpec newSpec = new GridSpec(this.buttonStyle.getField().get(), new Color(this.activeColor), this.buttonOpacity.getValue()).setColorCoords(colorX, colorY);
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((class_5321<class_1937>)class_1937.field_25179), newSpec);
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((class_5321<class_1937>)class_1937.field_25179), newSpec);
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (class_5321<class_1937>)class_1937.field_25179), newSpec);
        }
    }

    protected void saveAndClose() {
        this.updateGridSpecs();
        JourneymapClient.getInstance().getCoreProperties().gridSpecs.updateFrom(this.gridSpecs);
        JourneymapClient.getInstance().getCoreProperties().save();
        this.closeAndReturn();
    }

    protected void resetGridSpecs() {
        if (this.checkDay.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.day((class_5321<class_1937>)class_1937.field_25179), GridSpecs.DEFAULT_DAY.clone());
        }
        if (this.checkNight.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.night((class_5321<class_1937>)class_1937.field_25179), GridSpecs.DEFAULT_NIGHT.clone());
        }
        if (this.checkUnderground.getToggled().booleanValue()) {
            this.gridSpecs.setSpec(MapType.underground(0, (class_5321<class_1937>)class_1937.field_25179), GridSpecs.DEFAULT_UNDERGROUND.clone());
        }
        this.method_25396().clear();
        this.getRenderables().clear();
        this.method_25426();
    }

    public class_1043 getTileSample(MapType mapType) {
        if (mapType.isNight()) {
            return TextureCache.getTexture(TextureCache.TileSampleNight);
        }
        if (mapType.isUnderground()) {
            return TextureCache.getTexture(TextureCache.TileSampleUnderground);
        }
        return TextureCache.getTexture(TextureCache.TileSampleDay);
    }

    @Override
    protected void renderBottomBar(class_332 graphics) {
        DrawUtil.drawRectangle(graphics, 0.0, this.field_22790 - 30, this.field_22789, this.field_22790, 0, 0.6f);
    }
}

