/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager.group;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.util.tuple.Tuple2;
import journeymap.api.v2.common.event.common.WaypointGroupEvent;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.Constants;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.BasicImageButton;
import journeymap.client.ui.component.popupscreenbutton.ImagePopupButton;
import journeymap.client.ui.component.widgets.StringWidget;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypointmanager.ManagerSlot;
import journeymap.client.ui.waypointmanager.group.DeleteConfirmGroupPopup;
import journeymap.client.ui.waypointmanager.group.EditGroupPopup;
import journeymap.common.waypoint.WaypointGroupStore;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5481;
import net.minecraft.class_7843;
import net.minecraft.class_7847;
import net.minecraft.class_7852;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8133;
import net.minecraft.class_8667;
import org.jetbrains.annotations.NotNull;

public class GroupSlot
extends ManagerSlot {
    private final WaypointGroup group;
    private int width;
    private int height;
    boolean selected = false;
    private int x;
    private int y;
    private final boolean isAll;
    private ManagerSlot.ToolTipMeta tooltips;
    private class_8667 layout = class_8667.method_52742();

    public GroupSlot(WaypointGroup group, int width, int height) {
        this.group = group;
        this.width = width;
        this.height = height;
        this.buildTooltips();
        this.isAll = WaypointGroupStore.ALL.getGuid().equals(group.getGuid());
    }

    @Override
    public void repositionElements() {
        this.layout.method_48222();
        class_7843.method_48634((class_8021)this.layout, (class_8030)this.method_48202());
    }

    @Override
    public void init() {
        class_327 font = class_310.method_1551().field_1772;
        int count = this.group.getWaypointIds().size();
        String name = this.group.getName();
        this.layout = class_8667.method_52742();
        this.layout.method_52735(2);
        if (this.isAll) {
            this.layout.method_52736((class_8021)new class_7852(12, 12));
        } else {
            ImagePopupButton deleteButton = (ImagePopupButton)this.layout.method_52736(new ImagePopupButton<Tuple2>(12, 12, TextureCache.X_OUTLINE_SPRITE, class_124.field_1061.method_532(), Constants.getString("jm.waypoint.delete_group.label"), () -> new DeleteConfirmGroupPopup(this.group), this::deleteGroup));
            deleteButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.delete_group.label")));
        }
        if (this.isAll) {
            this.layout.method_52736((class_8021)new class_7852(12, 12));
            this.layout.method_52736((class_8021)new class_7852(12, 12));
        } else {
            ImagePopupButton editButton = (ImagePopupButton)this.layout.method_52736(new ImagePopupButton<WaypointGroup>(12, 12, TextureCache.OPTIONS_SPRITE, Constants.getString("jm.waypoint.group.edit.label"), () -> new EditGroupPopup((class_2561)class_2561.method_43471((String)"jm.waypoint.group.edit.label"), this.group), b -> {}));
            editButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"jm.waypoint.group.edit.label")));
            ((BasicImageButton)this.layout.method_52736((class_8021)new BasicImageButton(12, 12, TextureCache.POWER_SPRITE, (Integer)(this.group.isEnabled() ? 65280 : 0xFF0000), this::onEnable, this.getEnabledComponent(this.group.isEnabled())))).setTexWidth(10).setTexHeight(10).setXOffset(1).setYOffset(1).method_47400(class_7919.method_47407((class_2561)this.getEnabledComponent(this.group.isEnabled())));
        }
        this.layout.method_52737((class_8021)new StringWidget((class_2561)class_2561.method_43470((String)name), font.method_1727("XXXXXXXXX"), font).alignLeft(), class_7847.method_46481().method_46474().method_46469(1));
        this.layout.method_52738((class_8021)new StringWidget((class_2561)class_2561.method_43470((String)String.format("%s", count)), font.method_1727("000"), font).alignRight(), class_7847::method_46474);
        this.repositionElements();
    }

    private void onEnable(class_4185 button) {
        this.group.setEnabled(!this.group.isEnabled());
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.UPDATE));
    }

    private class_2561 getEnabledComponent(boolean enabled) {
        return enabled ? class_2561.method_43471((String)"jm.waypoint.disable_group") : class_2561.method_43471((String)"jm.waypoint.enable_group");
    }

    @Override
    public class_8133 getLayout() {
        return this.layout;
    }

    private void buildTooltips() {
        ArrayList<class_5481> tooltip = new ArrayList<class_5481>();
        tooltip.add(class_5481.method_30747((String)this.group.getName(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1075)));
        if (this.group.getDescription() != null) {
            tooltip.add(class_5481.method_30747((String)this.group.getDescription(), (class_2583)class_2583.field_24360.method_27706(class_124.field_1075)));
        }
        tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.group.edit.waypoints", this.group.getWaypointIds().size()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1060)));
        if (this.group.getTag() != null && !this.group.getTag().isEmpty()) {
            tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.group.edit.tag", this.group.getTag()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1060)));
        }
        tooltip.add(class_5481.method_30747((String)Constants.getString("jm.waypoint.group.edit.id", this.group.getGuid()), (class_2583)class_2583.field_24360.method_27706(class_124.field_1078)));
        this.tooltips = new ManagerSlot.ToolTipMeta(tooltip);
    }

    private void editGroup(class_4185 button) {
        new EditGroupPopup((class_2561)class_2561.method_43471((String)"jm.waypoint.group.edit.label"), this.group).display();
    }

    protected void deleteGroup(Tuple2<Boolean, Boolean> tuple2) {
        EventBus.post(new WaypointGroupEvent(this.group, WaypointGroupEvent.Context.DELETED, ((Boolean)tuple2.a()).booleanValue()));
    }

    @Override
    public int compareTo(@NotNull ManagerSlot o) {
        return 0;
    }

    @Override
    public Collection<SlotMetadata> getMetadata() {
        return null;
    }

    public boolean method_25400(char typedChar, int keyCode) {
        return false;
    }

    public boolean method_25404(int key, int value, int modifier) {
        return false;
    }

    @Override
    public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
        return new ArrayList();
    }

    @Override
    public SlotMetadata getLastPressed() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip() {
        return null;
    }

    @Override
    public SlotMetadata getCurrentTooltip(int mouseX, int mouseY) {
        AtomicBoolean showTooltip = new AtomicBoolean(true);
        this.layout.method_48206(widget -> {
            class_4185 button;
            if (widget instanceof class_4185 && (button = (class_4185)widget).method_49606()) {
                showTooltip.set(false);
            }
        });
        return showTooltip.get() ? this.tooltips : null;
    }

    @Override
    public void setEnabled(boolean enabled) {
    }

    @Override
    public int getColumnWidth() {
        return 0;
    }

    @Override
    public boolean contains(SlotMetadata slotMetadata) {
        return false;
    }

    public void method_25343(class_332 graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
        boolean drawHovered = isMouseOver;
        this.x = x;
        this.y = y;
        this.width = rowWidth;
        this.height = itemHeight;
        this.layout.method_46421(x + 3);
        this.layout.method_46419(y + 2);
        Integer color = drawHovered ? backgroundHover : background;
        float alpha = drawHovered ? 1.0f : 0.4f;
        DrawUtil.drawRectangle(graphics, x, y, rowWidth, itemHeight, color, alpha);
        if (this.selected) {
            DrawUtil.drawRectangle(graphics, x, y, rowWidth, itemHeight, backgroundHover, 1.0f);
        }
        this.layout.method_48206(widget -> widget.method_25394(graphics, mouseX, mouseY, partialTicks));
        if (this.group.colorOverride() && this.group.getColor() != null) {
            this.outline(graphics, x - 1, y - 1, rowWidth + 1, itemHeight + 1, this.group.getColor(), alpha * 2.0f);
        }
    }

    public void renderTransferStatus(class_332 graphics, boolean transferable) {
        int color = transferable ? 65280 : 0xFF0000;
        DrawUtil.drawRectangle(graphics, this.x, this.y, this.width, this.height, color, 0.4f);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        long clickTime = class_156.method_658();
        boolean bl = this.doubleclick = clickTime - this.lastClickTime < 250L && this.lastClickButton == button;
        if (button == 1 || this.doubleclick) {
            if (this.doubleclick) {
                this.editGroup(null);
            }
            this.lastClickTime = clickTime;
            this.lastClickButton = button;
            return true;
        }
        this.selected = this.method_25405(mouseX, mouseY);
        this.lastClickTime = clickTime;
        this.lastClickButton = button;
        return this.selected;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public WaypointGroup getGroup() {
        return this.group;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("group", (Object)this.group.getName()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupSlot groupSlot = (GroupSlot)o;
        return Objects.equals(this.group.getGuid(), groupSlot.group.getGuid());
    }

    public int hashCode() {
        return Objects.hash(this.group);
    }
}

